

def convolution(xs, ys):
    lx = len(xs)
    ly = len(ys)
    lz = lx + ly - 1

    zs = [0 for _ in range(lz)]
    for i in range(lz):
        for j in range(max(i - ly + 1, 0), min(lx, i+1)):
            k = i - j
            zs[i] += xs[j] * ys[k]
    return zs


def convolution_mod_n(n: int, xs, ys):
    assert len(xs) == n
    assert len(ys) == n

    zs = [0 for _ in range(n)]


    for i in range(n):
        for j in range(n):
            k = (i - j) % n
            zs[i] += xs[j] * ys[k] 
    
    return zs



# X = [0, 1, 1, 0, 1, 1, 0, 1, 1, 1]
# s = sum(X)
# X = [x/s for x in X]
# for i in range(12):
#     X = convolution_mod_n(len(X), X, X)
#     print(X)

if __name__ == "__main__":
    k = int(input())
    N = int(input())
    n = int(input())
    xs = [0 for _ in range(N)]
    for _ in range(n):
        xs[int(input())] += 1
    
    for _ in range(k):
        xs = convolution_mod_n(N, xs, xs)
    
    for x in xs:
        print(x)